package jme.test.texture;

import com.jme3.app.SimpleApplication;
import com.jme3.input.KeyInput;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue.ShadowMode;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.shadow.PssmShadowRenderer;
import com.jme3.shadow.PssmShadowRenderer.FilterMode;

public class TestPssmRendering extends SimpleApplication {
  private PssmShadowRenderer pssm;

  @Override
  public void simpleInitApp() {
    final Material whiteMat = new Material(assetManager,
        "Common/MatDefs/Light/Lighting.j3md");

    whiteMat.setFloat("Shininess", 0.1f);
    whiteMat.setBoolean("UseMaterialColors", true);
    whiteMat.setColor("Ambient", ColorRGBA.Black);
    whiteMat.setColor("Diffuse", new ColorRGBA(.5f, .5f, .5f, 1f));
    whiteMat.setColor("Specular", ColorRGBA.White);
    whiteMat.setReceivesShadows(true);

    whiteMat.setBoolean("VTangent", true);

    Geometry geo = new Geometry("floor", new Box(new Vector3f(-10, 0, -10),
        new Vector3f(10, 0f, 10)));
    geo.setMaterial(whiteMat);
    rootNode.attachChild(geo);

    final PointLight pl = new PointLight();
    pl.setPosition(new Vector3f(7, 2, 3));
    pl.setColor(new ColorRGBA(1f, 1f, 0.8f, 0.4f));
    pl.setRadius(0f);

    rootNode.addLight(pl);

    final Material teapotMat = new Material(assetManager,
        "Common/MatDefs/Light/Lighting.j3md");
    teapotMat.setFloat("Shininess", 0.9f);
    teapotMat.setBoolean("UseMaterialColors", true);
    teapotMat.setBoolean("UseAlpha", false);
    teapotMat.setColor("Ambient", ColorRGBA.Black);
    teapotMat.setColor("Diffuse", new ColorRGBA(1f, 0f, 0f, 1f));
    teapotMat.setColor("Specular", ColorRGBA.Gray);

    final Mesh b = new Sphere(20, 20, 1f);

    geo = new Geometry("Object", b);
    geo.setMaterial(teapotMat);
    geo.setShadowMode(ShadowMode.CastAndReceive);
    geo.setLocalTranslation(0, 1, 0);
    rootNode.attachChild(geo);

    rootNode.setShadowMode(ShadowMode.Receive);

    cam.setLocation(new Vector3f(3, 2, 5));
    cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);
    cam.setFrustumPerspective(45f, (float) cam.getWidth() / cam.getHeight(),
        1f, 1000f);
    cam.update();

    inputManager.addMapping("toggleShadow", new KeyTrigger(KeyInput.KEY_SPACE));
    inputManager.addListener(new ActionListener() {

      @Override
      public void onAction(final String name, final boolean isPressed,
          final float tpf) {
        if (!isPressed) {
          if (pssm == null) {
            final Vector3f shadowDir = new Vector3f(7, 2, 3).negate()
                .normalizeLocal();
            pssm = new PssmShadowRenderer(assetManager, 512, 3);
            pssm.setDirection(shadowDir);
            pssm.setShadowIntensity(.3f);
            pssm.setLambda(.2f);
            pssm.setFilterMode(FilterMode.PCF8);
            viewPort.addProcessor(pssm);
          } else {
            viewPort.removeProcessor(pssm);
            pssm = null;
          }
        }
      }
    }, "toggleShadow");
  }

  public static void main(final String[] args) {
    new TestPssmRendering().start();
  }
}
